/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.google.common.collect.ImmutableMap;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.util.CraftingUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.OptionalPredicate;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.modules.AbstractCraftingBuildingModule;
import com.minecolonies.coremod.colony.buildings.modules.settings.PlantationSetting;
import com.minecolonies.coremod.colony.buildings.modules.settings.SettingKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public class BuildingPlantation
extends AbstractBuilding {
    public static final ISettingKey<PlantationSetting> MODE = new SettingKey<PlantationSetting>(PlantationSetting.class, new ResourceLocation("minecolonies", "mode"));
    public static final Map<Item, PlantationItem> COMBINATIONS = ImmutableMap.builder().put((Object)Items.f_41909_, (Object)new PlantationItem(Items.f_41909_, Blocks.f_50130_, "sugar", 3)).put((Object)Items.f_41982_, (Object)new PlantationItem(Items.f_41982_, Blocks.f_50128_, "cactus", 3)).put((Object)Items.f_41911_, (Object)new PlantationItem(Items.f_41911_, Blocks.f_50571_, "bamboo", 3)).build();
    private static final String PLANTATION = "plantation";
    private final List<BlockPos> sand = new ArrayList<BlockPos>();

    public BuildingPlantation(IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.AXE, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return PLANTATION;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void registerBlockPosition(@NotNull Block block, @NotNull BlockPos pos, @NotNull Level world) {
        Block down;
        super.registerBlockPosition(block, pos, world);
        if (block == Blocks.f_49992_ && ((down = world.m_8055_(pos.m_7495_()).m_60734_()) == Blocks.f_50652_ || down == Blocks.f_50222_)) {
            this.sand.add(pos);
        }
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        super.deserializeNBT(compound);
        ListTag sandPos = compound.m_128437_("plantGround", 10);
        for (int i = 0; i < sandPos.size(); ++i) {
            this.sand.add(NbtUtils.m_129239_((CompoundTag)sandPos.m_128728_(i).m_128469_("pos")));
        }
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT();
        @NotNull ListTag sandCompoundList = new ListTag();
        for (BlockPos entry : this.sand) {
            @NotNull CompoundTag sandCompound = new CompoundTag();
            sandCompound.m_128365_("pos", (Tag)NbtUtils.m_129224_((BlockPos)entry));
            sandCompoundList.add((Object)sandCompound);
        }
        compound.m_128365_("plantGround", (Tag)sandCompoundList);
        return compound;
    }

    public List<PlantationSoilPosition> getAllSoilPositions() {
        return this.getSoilPositions((tag, item) -> true);
    }

    private List<PlantationSoilPosition> getSoilPositions(BiPredicate<String, Item> filter) {
        ArrayList<PlantationSoilPosition> filtered = new ArrayList<PlantationSoilPosition>();
        if (this.tileEntity != null && !this.tileEntity.getPositionedTags().isEmpty()) {
            Map<String, Item> availableTags = COMBINATIONS.entrySet().stream().collect(Collectors.toMap(k -> ((PlantationItem)k.getValue()).getTag(), Map.Entry::getKey));
            for (Map.Entry<BlockPos, List<String>> entry : this.tileEntity.getPositionedTags().entrySet()) {
                Optional<String> foundTag = entry.getValue().stream().filter(availableTags::containsKey).findFirst();
                if (!foundTag.isPresent()) continue;
                Item item = availableTags.get(foundTag.get());
                if (!filter.test(foundTag.get(), item)) continue;
                filtered.add(new PlantationSoilPosition(this.getPosition().m_141952_((Vec3i)entry.getKey()), COMBINATIONS.get(item)));
            }
        }
        return filtered;
    }

    public List<Item> getAvailablePlants() {
        String setting = this.getSetting(MODE).getValue();
        ArrayList<Item> items = new ArrayList<Item>();
        if (setting.contains(Items.f_41909_.m_5524_())) {
            items.add(Items.f_41909_);
        }
        if (setting.contains(Items.f_41982_.m_5524_())) {
            items.add(Items.f_41982_);
        }
        if (setting.contains(Items.f_41911_.m_5524_())) {
            items.add(Items.f_41911_);
        }
        if (items.isEmpty()) {
            items.add(Items.f_41909_);
            Log.getLogger().warn("Plantation plant setting contains none of the preconfigured plants, please report this to the developers!");
        }
        return items;
    }

    public static class PlantationSoilPosition {
        private final BlockPos position;
        private final PlantationItem combination;

        private PlantationSoilPosition(BlockPos position, PlantationItem combination) {
            this.position = position;
            this.combination = combination;
        }

        public BlockPos getPosition() {
            return this.position;
        }

        public PlantationItem getCombination() {
            return this.combination;
        }
    }

    public static class PlantationItem {
        private final Item item;
        private final Block block;
        private final String tag;
        private final int minimumLength;

        private PlantationItem(Item item, Block block, String tag, int minimumLength) {
            this.item = item;
            this.block = block;
            this.tag = tag;
            this.minimumLength = minimumLength;
        }

        public Item getItem() {
            return this.item;
        }

        public Block getBlock() {
            return this.block;
        }

        public String getTag() {
            return this.tag;
        }

        public int getMinimumLength() {
            return this.minimumLength;
        }
    }

    public static class CraftingModule
    extends AbstractCraftingBuildingModule.Crafting {
        public CraftingModule(JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        @NotNull
        public OptionalPredicate<ItemStack> getIngredientValidator() {
            return CraftingUtils.getIngredientValidatorBasedOnTags(BuildingPlantation.PLANTATION).combine(super.getIngredientValidator());
        }

        @Override
        public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
            if (!super.isRecipeCompatible(recipe)) {
                return false;
            }
            Optional<Boolean> isRecipeAllowed = CraftingUtils.isRecipeCompatibleBasedOnTags(recipe, BuildingPlantation.PLANTATION);
            return isRecipeAllowed.orElse(false);
        }
    }
}

